//=============================================================================
// ExPrice_MZ.js
// ----------------------------------------------------------------------------
/*:
 * @target MZ
 * @plugindesc extention for item's price
 * @author Um
 * 
 * @help This plugin has no plugin command.
 * 
 * You can set the price above the database
 * upper limit of 99999 by writing the following
 * in the item's memo field.
 * <ExPrice:10000000>
 * 
 */


/*:ja
 * @target MZ
 * @plugindesc アイテムなどの価格の拡張
 * @author 温州みかん
 * 
 * @help プラグインコマンド及びパラメーターはありません
 * アイテムのメモ欄に以下のように記載すると、その価格をデータベース上限値99999を超えて設定できます
 * <ExPrice:10000000>
 */
(() => {

"use strict";//公式オススメの記述

const pluginName = "ExPrice_MZ";

const _Window_ShopBuy_prototype_price = Window_ShopBuy.prototype.price;
Window_ShopBuy.prototype.price = function(item) {
	_Window_ShopBuy_prototype_price.apply(this, arguments);
        if(item.meta.ExPrice > 0) {
	        return item.meta.ExPrice || 0;
	    }else{
            return this._price[this._data.indexOf(item)] || 0;
	}	
};

})();